#include <windows>
#include <setupapi>
#include <assert>
#include <iostream>
//#include "C:\\WINDDK\\6000\\inc\\api\\usbiodef.h"
using namespace std;

void displayError(const char* msg){
  cout << msg << endl;
  system("PAUSE");
  exit(0);
};
//---------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete x;
  x = NULL;
}
//---------------------------------------------------------
/*A5DCBF10-6530-11D2-901F-00C04FB951ED */
static GUID GUID_DEVINTERFACE_USB_DEVICE =
{0xA5DCBF10, 0x6530, 0x11D2, {0x90, 0x1F, 0x00, 0xC0,
                              0x4F, 0xB9, 0x51, 0xED}};

/*3ABF6F2D-71C4-462a-8A92-1E6861E6AF27 */
static GUID GUID_DEVINTERFACE_USB_HOST_CONTROLLER =
{0x3abf6f2d, 0x71c4, 0x462a, {0x8a, 0x92, 0x1e, \
                              0x68, 0x61, 0xe6, 0xaf, 0x27}};

/*F18A0E88-C30C-11D0-8815-00A0C906BED8 */
static GUID GUID_DEVINTERFACE_USB_HUB =
{0xf18a0e88, 0xc30c, 0x11d0,{0x88, 0x15, 0x00, \
                             0xa0, 0xc9, 0x06, 0xbe, 0xd8}};

/*4D1E55B2-F16F-11CF-88CB-001111000030*/
static GUID GUID_DEVINTERFACE_HID =
{0x4D1E55B2, 0xF16F, 0x11CF, { 0x88, 0xCB, 0x00, \
                             0x11, 0x11, 0x00, 0x00, 0x30}};

/*53F56307-B6BF-11D0-94F2-00A0C91EFB8B*/
static GUID GUID_DEVINTERFACE_DISK =
{0x53f56307, 0xb6bf, 0x11d0, {0x94, 0xf2, 0x00, \
                              0xa0, 0xc9, 0x1e, 0xfb, 0x8b}};


//---------------------------------------------------------
DWORD memberIndex = 0;
DWORD deviceInterfaceDetailDataSize;
DWORD requiredSize;

HDEVINFO deviceInfoSet;
SP_DEVICE_INTERFACE_DATA deviceInterfaceData;
PSP_DEVICE_INTERFACE_DETAIL_DATA deviceInterfaceDetailData = NULL;

int main(){

   deviceInfoSet = SetupDiGetClassDevs(&GUID_DEVINTERFACE_USB_DEVICE,
                   NULL, NULL, DIGCF_PRESENT | DIGCF_INTERFACEDEVICE);
   if (deviceInfoSet == INVALID_HANDLE_VALUE)
      displayError("Nie zidentyfikowano podczonych urzdze.\n");

   deviceInterfaceData.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);

   while(SetupDiEnumDeviceInterfaces(deviceInfoSet, NULL,
                                     &GUID_DEVINTERFACE_USB_DEVICE,
                                     memberIndex, &deviceInterfaceData)){
       memberIndex++; //inkrementacja numeru interfejsu

       SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
                             NULL, 0, &deviceInterfaceDetailDataSize, NULL);

       deviceInterfaceDetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)
                              new DWORD[deviceInterfaceDetailDataSize];

       deviceInterfaceDetailData->cbSize=sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);

       if (!SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
                       deviceInterfaceDetailData, deviceInterfaceDetailDataSize,
                       &requiredSize, NULL)){
           releaseMemory(deviceInterfaceDetailData);
           SetupDiDestroyDeviceInfoList(deviceInfoSet);
           //displayError("Nie mona pobrac informacji o interfejsie.\n");
       }

       cout << deviceInterfaceDetailData->DevicePath << endl;
       releaseMemory(deviceInterfaceDetailData);
    };//koniec while

   SetupDiDestroyDeviceInfoList(deviceInfoSet);
   cout << endl;
   system("PAUSE");
   return 0;
}
//---------------------------------------------------------



